//%attributes = {}
// Method: co_ CreditLimitCheck
// 2005.10.06-12:55:43 / ME
// © Copyright 2005 Manage Applications
// Purpose: 
// Checks if the company has exceeded the credit limit
// or if it has a sales ban
// ------------------------------------------------------------

C_TEXT:C284($0; $co_tResult; $1; $co_tCompany)
C_REAL:C285($2; $co_rCreditLimit; $co_rDueAmount)
C_POINTER:C301($co_pFldNumArr; $co_pFldArr)
C_LONGINT:C283($co_lIndex)

$co_tCompany:=$1
$co_rCreditLimit:=$2

Case of 
	: ($co_rCreditLimit<0)  // negative value means sales ban
		$co_tResult:=_lang Current("Company is in sales ban")
	: ($co_rCreditLimit=0)
		$co_tResult:=""  // no credit limit set, don't check
	Else 
		_str:=$co_tCompany
		_qry Fld(in_kTbl; in_kCompany_id; "="; ->_str; "&"; kFalse)
		_long:=1  // select invoices that have not been paid yet
		_qry Fld(in_kTbl; in_kState; "<"; ->_long; "*"; kTrue)
		
		$co_pFldNumArr:=_fld PtrToFldNumArr(in_kComing_Total; in_kCurrency_id)
		$co_pFldArr:=_fld PtrToFldArr(in_kComing_Total; in_kCurrency_id)
		_sel SEL_TO_ARR($co_pFldNumArr; $co_pFldArr)
		
		$co_rDueAmount:=0
		// calculate the sum; convert currency using the current sell rate
		For ($co_lIndex; 1; Size of array:C274(in_arComing_Total))
			$co_rDueAmount:=$co_rDueAmount+cur_ SellConvert(in_arComing_Total{$co_lIndex}; in_asCurrency_id{$co_lIndex}; cur_ DefaultCurre)
		End for 
		
		If ($co_rDueAmount>$co_rCreditLimit)
			$co_tResult:=_lang Current("Credit limit exceeded")
		Else 
			$co_tResult:=""  // everything ok      
		End if 
End case 

$0:=$co_tResult
